﻿using System;
using System.Collections.Generic;
using System.Linq;
using DesktopNLayerSingleAssembly.DAL;

namespace DesktopNLayerSingleAssembly.BLL
{
    class HospitalManagers
    {
        public List<HospitalStaff> GetDoctors()
        {
            using (var staffCtx = new HospitalDataContext())
            {
                return
                    (from staff in staffCtx.HospitalStaffs
                     where staff.Position == "Lekarz"
                     select staff)
                     .ToList();
            } 
        }

        private List<string> positions = new List<string>
        {
            "Lekarz", "Pielęgniarka", "Starzysta1", "Starzysta2"
        };

        public void AddStaff(string name, string position)
        {
            if (!positions.Contains(position))
            {
                throw new ArgumentException("Niewłaściwe stanowisko", "position");
            }

            using (var staffCtx = new HospitalDataContext())
            {
                staffCtx
                    .HospitalStaffs
                    .InsertOnSubmit
                    (
                        new HospitalStaff
                        {
                            Name = name,
                            Position = position
                        }
                    );

                staffCtx.SubmitChanges();
            }
        }
    }
}
